/*  Löschen von veralteten Backup-Versionen der gegebenen Tabelle aus der Sicherung der Plantafel (Tabelle
    scheduling.scheduling_log). Damit soll nur die gegebene Anzahl (Parameter _max_num_of_backups) behalten werden. */
SELECT tsystem.function__drop_by_regex( 'scheduling_log__old_version__delete', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.scheduling_log__old_version__delete( IN _TableName varchar, IN _max_num_of_backups integer default 5 ) RETURNS VOID AS $$
  BEGIN
    DELETE FROM scheduling.scheduling_log
    WHERE concat_ws( '  ', sl_tablename, sl_time ) IN ( SELECT tn_time
                                                        FROM ( SELECT
                                                                 ROW_NUMBER () OVER (ORDER BY sl_time DESC) AS lfd_id,
                                                                 concat_ws( '  ', sl_tablename, sl_time )   AS tn_time
                                                               FROM scheduling.scheduling_log
                                                               GROUP BY sl_tablename, sl_time
                                                               HAVING sl_tablename = _TableName
                                                            ) AS sub
                                                        WHERE lfd_id > _max_num_of_backups
                                                      );
  END $$ LANGUAGE plpgsql;